<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/"><?php echo e(__('Main')); ?></a>
                    </li>
                    <li class="breadcrumb-item">
                        <a wire:navigate href="/it_req"><?php echo e(__('Inv Transfer Request')); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <?php echo e(__('Detail')); ?>

                    </li>
                </ol>

                <div>
                    <button data-bs-target="#modalSign2" data-bs-toggle="modal" type="button"
                        class="custom-button1 btn-sm" <?php if($no->sign == 'Y'): ?> disabled <?php endif; ?>>
                        <!--[if BLOCK]><![endif]--><?php if($isloading): ?>
                            <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                                aria-hidden="true"></span>
                            <span id="innerSpan">Loading . . .</span>
                        <?php else: ?>
                            <?php echo e(__('Save')); ?>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </button>
                    <button wire:click="close" type="button"
                        class="button-custom-secondary btn-sm ml-2"><?php echo e(__('Close')); ?></button>
                </div>

            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="">
                    <div class="card" style="margin-top: -1rem; margin-bottom: 1rem;">
                        <div class="m-2">
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary"><?php echo e(__('IT Request Detail No. ')); ?> <span
                                        class=""><?php echo e($no->no); ?></span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <h6 class="card-title text-secondary"><?php echo e(__('Date : ')); ?> <span
                                        class=""><?php echo e($no->date); ?></span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small mb-1">
                                <h6 class="card-title text-secondary"><?php echo e(__('Remark : ')); ?> <span
                                        class=""><?php echo e($no->comments); ?></span></h6>
                            </div>
                            <div
                                class="d-flex flex-column flex-md-row align-items-center justify-content-between small">
                                <button type="button" class="custom-button1 btn-sm ml-2"
                                    <?php if($no->sign == 'N'): ?> data-bs-target="#modalAddItemReq"
                                    data-bs-toggle="modal" data-bs-dismiss="modal" <?php else: ?> disabled <?php endif; ?>><?php echo e(__('Add Item')); ?></button>
                            </div>
                        </div>

                    </div>

                    <div class="table-responsive">
                        <table id="table" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%;">
                            <thead>
                                <tr>
                                    <th scope="col" style="border-top-left-radius: .5rem">#</th>
                                    <th scope="col"><?php echo e(__('Code')); ?></th>
                                    <th scope="col"><?php echo e(__('Barcode')); ?></th>
                                    <th scope="col"><?php echo e(__('Name')); ?></th>
                                    <th scope="col"><?php echo e(__('Qty Send')); ?></th>
                                    <th scope="col" style="border-top-right-radius: .5rem"><?php echo e(__('Qty Receive')); ?>

                                    </th>


                                </tr>
                            </thead>

                            <tbody class="small">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr wire:key="<?php echo e($detail->code); ?>">
                                        <th scope="col"><?php echo e($key + 1); ?></td>
                                        <td><?php echo e($detail->code); ?></td>
                                        <td><?php echo e($detail->barcode); ?></td>
                                        <td><?php echo e($detail->name); ?></td>
                                        <td><?php echo e(number_format($detail->qty)); ?></td>

                                        <td x-data="{ isFocused: false }">
                                            <!--[if BLOCK]><![endif]--><?php if($no->sign == 'N'): ?>
                                                <input type="number" wire:model="quantities.<?php echo e($key); ?>"
                                                    class="form-control p-0" id="bg-qty-req"
                                                    x-on:focus="isFocused = true"
                                                    x-on:blur="isFocused = false; $wire.updateQuantity(<?php echo e($key); ?>, '<?php echo e($detail->code); ?>')">
                                            <?php else: ?>
                                                <?php echo e($detail->qty_receive); ?>

                                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    </div>

                    <div wire:ignore.self>
                        <table id="table" class="table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col"></th>
                                    <th scope="col" style="text-align: right;"><?php echo e(__('Total Qty')); ?></th>
                                    <th scope="col" style="text-align: right; width: 120px;"><?php echo e(__('Total Qty Receive')); ?></th>
                                   
                                </tr>
                            </thead>

                            <tbody class="small">

                                <tr>
                                    <td colspan="2">Total</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <?php echo e(number_format($details->sum('qty'), 0, ',', ',')); ?></td>
                                    <td style="text-align: right; width: 120px;">
                                        <?php
                                            $totalQty = array_sum(array_map('floatval', $quantities));
                                        ?>
                                        <?php echo e(number_format($totalQty, 0, ',', ',')); ?>

                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>

    <div wire:ignore.self class="modal fade" id="modalSign" aria-hidden="true" aria-labelledby="modalSignLabel"
        tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Sign IT Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="d-flex justify-content-center align-items-center">
                        <button type="button"
                            <?php if($no->status == 'Same'): ?> disabled <?php else: ?> wire:click="sendEmail" <?php endif; ?>
                            class="button-custom-info btn-sm mx-auto">
                            <!--[if BLOCK]><![endif]--><?php if($isloading): ?>
                                <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status"
                                    aria-hidden="true"></span>
                                <span id="innerSpan">Loading . . .</span>
                            <?php else: ?>
                                <?php echo e(__('Send Email')); ?>

                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </button>
                        <button type="button" class="custom-button1 btn-sm mx-auto" data-bs-target="#modalSign2"
                            data-bs-toggle="modal" data-bs-dismiss="modal"><?php echo e(__('Sign IT Request')); ?></button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="button-custom-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modalSign2" aria-hidden="true" aria-labelledby="modalSignLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Sign IT Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="d-flex justify-content-center align-items-center"> Are you sure to Sign the It Request?
                    </h4>
                    <h4 class="d-flex justify-content-center align-items-center">It's cant be Revert. </h4>
                </div>
                <div class="modal-footer">
                    <button class="button-custom-success mr-auto" wire:click="save"
                        data-bs-dismiss="modal">Sign</button>

                    <button class="button-custom-danger" data-bs-dismiss="modal">Back</button>
                </div>
            </div>
        </div>
    </div>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pos.it.itreqin.add-item-req', ['no' => $no]);

$__html = app('livewire')->mount($__name, $__params, 'r6KkaRA', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    
    <script>
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });
    </script>


</div>
<?php /**PATH C:\laragon\www\rybc\resources\views/livewire/pos/it/itreqin/itreq-detail.blade.php ENDPATH**/ ?>