<div>
    <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalProcessDiscount" tabindex="-1"
        aria-labelledby="modalNewItemLabel" aria-hidden="true" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Process Discount <!--[if BLOCK]><![endif]--><?php if($name !== ''): ?>
                            <br><span class="text-primary"><?php echo e($name); ?></span>
                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </h5>
                </div>

                <div class="modal-body">
                    <div class="col mb-3" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
                        <div class="form-group">
                            <label class="small text-muted mb-1">Kode Produk</label>
                            <div class="d-flex">
                                <input type="text" id="searchitem" class="form-control" wire:model.live="searchitem"
                                    placeholder="Type to search..." autofocus autocomplete="off"
                                    @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, <?php echo e(sizeof($products) - 1); ?>)"
                                    @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                    x-on:keydown.enter="
                                if(selectedIndex == -1) {
                                    $wire.selectProductByName();
                                } else {
                                    $wire.selectProduct(selectedIndex);
                                    selectedIndex = -1; 
                                }">
                            </div>

                            <?php if($selectedProduct === null && sizeof($products) > 0): ?>
                                <div class="dropdown-menu d-block py-0" style="width: 770px">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndex === <?php echo e($index); ?> }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button" wire:click="byClick('<?php echo e($product->code); ?>')"
                                                    class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndex === <?php echo e($index); ?> }">
                                                    <?php echo e($product->code); ?> || <?php echo e($product->name); ?> ||
                                                    <?php echo e($product->price); ?> || <?php echo e($product->U_IDU_Brand); ?>

                                                </button>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <table class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Promo</th>
                                <th>Pack</th>
                                <th>Promo Tipe</th>
                                <th>Benefit</th>
                                <th class="text-center">#</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($cart['itemcode']); ?></td>
                                    <td><?php echo e($cart['itemname']); ?></td>
                                    <td><?php echo e('Rp ' . number_format($cart['itemprice'], 0, ',', '.')); ?></td>
                                    <td><?php echo e($cart['promo']); ?></td>
                                    <td><?php echo e($cart['pack']); ?></td>
                                    <td><?php echo e($cart['promotipe']); ?></td>
                                    <td><?php echo e($cart['benefit']); ?></td>
                                    <td class="text-center">
                                        <button wire:click="deleteFromCarts(<?php echo e($index); ?>)"
                                            class="badge button-custom-danger" type="button">Delete</button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr class="text-center" width="100%">
                                    <td colspan="9">Empty</td>
                                </tr>
                            <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>

                    <div class="" wire:key="<?php echo e($refreshKey); ?>">
                        <!--[if BLOCK]><![endif]--><?php if($isSuggestion): ?>
                            <div class="container mt-4">
                                <div class="row">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $suggestion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-4">
                                            <div class="card border-0 shadow animate__animated"
                                                style="background-color: #EEF6F9" x-data="{ isFadeOut: false }"
                                                :class="{ 'animate__fadeInRight': !
                                                isFadeOut, 'animate__fadeOutLeft': isFadeOut }"
                                                x-show="!isFadeOut" x-transition:enter="animate__fadeInRight"
                                                x-transition:leave="animate__fadeOutLeft duration-300ms"
                                                x-transition:leave-end="opacity-0">
                                                <div class="suggestion-card">
                                                    <h6 class="suggestion"><?php echo e(Str::limit($item->name, 18, '...')); ?>

                                                    <br>( Pack
                                                        <?php echo e($item->pack); ?> )</h6>
                                                    <h6 class="suggestion"><?php echo e($item->barcode); ?> </h6>
                                                    <!--[if BLOCK]><![endif]--><?php if($index === 0): ?>
                                                        <div class="add-to-cart"
                                                            wire:click="addSuggestionFirst('<?php echo e($item->code); ?>', '<?php echo e($item->no); ?>')"
                                                            @click="isFadeOut = true">Add to Cart</div>
                                                    <?php else: ?>
                                                        <div class="add-to-cart"
                                                            wire:click="addSuggestion('<?php echo e($item->code); ?>', '<?php echo e($item->no); ?>')"
                                                            @click="isFadeOut = true">Add to Cart</div>
                                                    <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                        <?php endif; ?> <!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="custom-button1" data-bs-dismiss="modal" data-bs-toggle="modal"
                           >Back</button>
                        <button type="button" id="saveButton" class="custom-button1"
                            <?php if($fulfilled): ?> wire:click="save" data-bs-dismiss="modal" <?php else: ?> disabled <?php endif; ?>>Save</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#modalProcessDiscount').on('shown.bs.modal', function() {
                trueSuggestion();
            });
        });
    </script>

</div>
<?php /**PATH C:\laragon\www\Posprorycroft\resources\views/livewire/cashier/process-discount.blade.php ENDPATH**/ ?>