<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" data-bs-theme="">

<head>
    <script>
        (function() {
            const storedTheme = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const theme = storedTheme || (prefersDark ? 'dark' : 'light');
            document.documentElement.setAttribute('data-bs-theme', theme);
        })();
    </script>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/android-chrome-192x192.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/android-chrome-512x512.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/apple-touch-icon.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon-16x16.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon-32x32.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('assets/favicon/favicon.ico')); ?>" type="image/x-icon">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name')); ?> - Bestari Jaya</title>

    <link href="https://fastly.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <!-- Include Bootstrap 5 CSS -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Include DataTables Bootstrap 5 extension CSS -->
    <link href="<?php echo e(asset('assets/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">

    <style>
        .modal {
            backdrop-filter: blur(5px);
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
</head>

<body>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip({
                'placement': 'right'
            });
        });
    </script>

    <div id="app" class="app-cashier">

        <div class="w-full">

            <div class="d-flex ">
                <div class="sidebar py-5 text-white">
                    <div>
                        <div class="sidebar-icon">
                            <a class="navbar-brand" href="<?php echo e(url('/')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="home">
                                <img src="<?php echo e(asset('assets/home (2).png')); ?>">
                            </a>
                            
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('welcome.*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('welcome.dashboard')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="cashier"><?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/shopping-bag.png')); ?>">
                            </a>
                        </div>

                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('member.*') ? 'active' : ''); ?>"
                                href="<?php echo e(route('member.index')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="member"><?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/membership.png')); ?>">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('item') ? 'active' : ''); ?>"
                                href="<?php echo e(route('item')); ?>" data-toggle="tooltip" rel="tooltip" data-placement="right"
                                title="item"><?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/product (1).png')); ?>">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('opname') ? 'active' : ''); ?>"
                                href="<?php echo e(route('opname')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="opname"><?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/product.png')); ?>">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('activity-log') ? 'active' : ''); ?>"
                                href="<?php echo e(route('activity-log')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="activity log"><?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/time-management.png')); ?>">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('salesemp') ? 'active' : ''); ?>"
                                href="<?php echo e(route('salesemp')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="sales employees"><?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/employee.png')); ?>">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('it.itin') || request()->routeIs('it.itout') || request()->routeIs('it.itreq') || request()->routeIs('it.itreqout') ? 'active' : ''); ?>"
                                href="<?php echo e(route('it.itin')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="it">
                                <img src="<?php echo e(asset('assets/in-out.png')); ?>">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link dropdown-toggle <?php echo e(request()->routeIs('report.*') ? 'active' : ''); ?>"
                                href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/report.png')); ?>">
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" href="<?php echo e(route('report.reportinvoicereturnsale')); ?>"
                                        id="ddown-style"><?php echo e(__('Report Sale & Return Sale')); ?></a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="<?php echo e(route('report.reporttransactionmember')); ?>"
                                        id="ddown-style"><?php echo e(__('Member')); ?></a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="<?php echo e(route('report.voucher')); ?>"
                                        id="ddown-style"><?php echo e(__('Voucher')); ?></a></li>
                            </ul>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link <?php echo e(request()->routeIs('synchronization') ? 'active' : ''); ?>"
                                href="<?php echo e(route('synchronization')); ?>" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="synchronization"><?php echo e(__('')); ?>

                                <img src="<?php echo e(asset('assets/sync.png')); ?>">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <button id="toggleThemeButton" class="bg-transparent" style="border: none;"
                                data-toggle="tooltip" rel="tooltip" data-placement="right" title="color mode"
                                height="25px" width="25px">
                                <i id="themeIcon" class="bi bi-moon-fill"></i>
                            </button>
                        </div>
                    </div>

                    <div>
                        <div class="sidebar-icon">

                            <a id="navbarDropdown user-name" class="nav-link dropdown-toggle" href="#"
                                role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                v-pre>
                                <?php echo e(Auth::user()->name); ?>

                            </a>
                            <img src="<?php echo e(asset('assets/logout.png')); ?>">

                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="<?php echo e(route('changepass')); ?>" id="ddown-style">
                                    <?php echo e(__('Change Password')); ?>

                                </a>
                                <a class="dropdown-item" href="<?php echo e(route('settings')); ?>" id="ddown-style">
                                    <?php echo e(__('Settings')); ?>

                                </a>

                                <a class="dropdown-item" href="<?php echo e(route('logouts')); ?>" id="ddown-style"
                                    onclick="event.preventDefault();
                                                        document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>

                                <form id="logout-form" action="<?php echo e(route('logouts')); ?>" method="POST"
                                    class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>

                <div id="cashier" class="flex-grow-1 d-flex flex-column">
                    <main class="flex-grow-1 d-flex flex-column">
                        <?php echo $__env->yieldContent('content'); ?>

                        <script src="<?php echo e(asset('assets/js/sweetalert2@11.js')); ?>"></script>

                        <?php if (isset($component)) { $__componentOriginal71c6471fa76ce19017edc287b6f4508c = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal71c6471fa76ce19017edc287b6f4508c)): ?>
<?php $component = $__componentOriginal71c6471fa76ce19017edc287b6f4508c; ?>
<?php unset($__componentOriginal71c6471fa76ce19017edc287b6f4508c); ?>
<?php endif; ?>
                    </main>
                </div>
            </div>

            
            
            
            

        </div>

        <!-- Include jQuery -->
        <script src="<?php echo e(asset('assets/js/jquery-3.7.0.js')); ?>"></script>

        <!-- Include DataTables core script -->
        <script src="<?php echo e(asset('assets/js/jquery.dataTables.min.js')); ?>"></script>

        <!-- Include DataTables Bootstrap 5 extension script -->
        <script src="<?php echo e(asset('assets/js/dataTables.bootstrap5.min.js')); ?>"></script>
        <script>
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                var table = $('#example').DataTable();

                $(document).keypress(function(e) {
                    // Check if the pressed key is '/' (forward slash)
                    if (e.which == 47) {
                        e.preventDefault(); // Prevent default action
                        // Focus on the search input field of the DataTable
                        $('.dataTables_filter input').focus();
                    }
                    // Check if the pressed key is '.' (period) for next page
                    else if (e.which == 46) {
                        e.preventDefault(); // Prevent default action
                        table.page('next').draw('page');
                    }
                    // Check if the pressed key is ',' (comma) for previous page
                    else if (e.which == 44) {
                        e.preventDefault(); // Prevent default action
                        table.page('previous').draw('page');
                    }
                });
            });

            document.addEventListener("DOMContentLoaded", function() {
                const currentTheme = localStorage.getItem('theme') ||
                    'light'; // Get the stored theme or default to 'dark'
                document.documentElement.setAttribute('data-bs-theme', currentTheme);

                // Set the icon based on the theme
                const themeIcon = document.getElementById('themeIcon');
                if (currentTheme === 'dark') {
                    themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
                } else {
                    themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
                }
            });

            const toggleThemeButton = document.getElementById('toggleThemeButton');
            toggleThemeButton.addEventListener('click', () => {
                const currentTheme = document.documentElement.getAttribute('data-bs-theme');
                let newTheme = 'dark';

                if (currentTheme === 'dark') {
                    newTheme = 'light';
                    themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
                } else {
                    newTheme = 'dark';
                    themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
                }

                document.documentElement.setAttribute('data-bs-theme', newTheme);
                localStorage.setItem('theme', newTheme); // Store the theme in local storage
            });

            document.addEventListener("DOMContentLoaded", function() {
                var navLinks = document.querySelectorAll('.nav-link');
                var currentPage = window.location.pathname.split('/').pop();

                navLinks.forEach(function(link) {
                    if (link.getAttribute('href') === currentPage) {
                        link.classList.add('active');
                    }
                });
            });
        </script>
        <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH C:\laragon\www\rybc\resources\views/layouts/app.blade.php ENDPATH**/ ?>