<div class="row justify-content-center mt-2">
    <div class="col">
        <livewire:returnsale.additem :selectedItems="$selectedItems" :selectedItemsPrice="$selectedItemsPrice" />
        <div class="">
            <div class="">
                @if ($selectedItems)
                    {{-- <button type="button" wire:click="openInput" class="custom-button1 btn-sm"
                       > Open Input
                </button> --}}
                    <button type="button" wire:click="openModal" data-bs-toggle="modal" data-bs-target="#exampleModal"
                        class="custom-button1 btn-sm"> Input
                    </button>
                @endif
                <table class="my-table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th style="border-top-left-radius: 1rem">
                                
                            </th>
                            <th>Code</th>
                            <th>Name</th>
                            <th>Price</th>
                            <th style="border-top-right-radius: 1rem">Qty</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($selectedCarts as $cart)
                            <tr wire:key="cart-{{ $cart['code'] }}">
                                <td>
                                    @if($cart['price'] == 0)
                                    <input type="checkbox" disabled value="{{ $cart['code'] }}">
                                    @else
                                    <input type="checkbox" wire:model.live="selectedItems" value="{{ json_encode(['code' => $cart['code'], 'pack' => $cart['pack']]) }}">
                                    @endif
                                </td>
                                <td>{{ $cart['code'] }}</td>
                                <td>{{ $cart['name'] }}</td>
                                <td>{{ $cart['price'] }}</td>
                                <td>
                                    {{ $cart['qty'] }}
                                </td>
                            </tr>
                        @empty
                            <tr class="text-center" width="100%">
                                <td colspan="6">
                                    Empty
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        {{-- @livewire('returnsale.inputreturn') --}}
        {{-- @if ($showInputReturn)
            <livewire:returnsale.inputreturn :selectedItemsDetails="$selectedItemsDetails" :invoice="$invoice" :sales="$sales" :member="$member"
                :selectedItems="$selectedItems" :selectedItemsPrice="$selectedItemsPrice" :itemReturnDetails="$itemReturnDetails" />
        @endif --}}
        @if ($isData)
        <hr>
        <livewire:returnsale.returntable :data="$data"/>
        @endif
    </div>
    <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalZ" tabindex="-1"
        aria-labelledby="modalZLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Alert</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Printer Not Found, Data Saved Without Printing !
                </div>
                <div class="modal-footer">
                    <button type="button" class="custom-button1" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>
    <livewire:returnsale.newitem />

    @if($isCheapestReturn)
    <livewire:returnsale.cheapest-item :cartData="$cartData"/>
    @endif

</div>
@livewireScripts
<script>
    Livewire.on('closeModalDisc', () => {
        $('#selectDiscount').modal('hide');
    });
    Livewire.on('openModalCheapestReturn', () => {
        setTimeout(() => {
            $('#modalCheapestReturn').modal('show');

        }, 100); // Adjust the delay as needed after the page has finished reloading
        console.log('kalkulus')
    });
    Livewire.on('openTheModal', () => {
        $('#selectDiscount').modal('show');

        setTimeout(() => {
            @this.modalDiscOpen();
            // Focus on the radio button
            var firstRadioButton = document.querySelector('input[type="radio"][name="promo"]');
            if (firstRadioButton) {
                firstRadioButton.focus();
            }
        }, 500); // Adjust the delay as needed after the page has finished reloading
    });

    document.addEventListener('keydown', function(event) {
        if (event.key === 'F1') {
            event.preventDefault();
            // Livewire.dispatch('openthemodal');
            @this.F1Open();
        }
    });

    Livewire.on('openTheModal', () => {
        $('#invoiceReturnModal').modal('show');
    });
    Livewire.on('openModal', () => {
        $('#invoiceReturnModal').modal('show');
    });
    Livewire.on('openModalItem', () => {
        $('#modalNewItem').modal('show');
    });
    Livewire.on('closeModalReturn', () => {
        $('#invoiceReturnModal').modal('hide');
    });

    Livewire.on('close-modal', () => {
        $('#exampleModal').modal('hide'); 
    });

    Livewire.on('printernotfound', () => {
        $('#modalZ').modal('show');
    });
    
    Livewire.on('clearSearch', (params) => {
        document.getElementById('searchitem').value = '';

    });
</script>
