<div>
    <div class="col">
        <div class="">
            <h5>Remaining Price : {{ $data['overalPrice'] }}</h5>
            <hr>
            <div class="card-body">
                <table class="my-table" style="width:100%">
                    <thead>
                        <tr>
                            <th style="border-top-left-radius: .5rem">Code</th>
                            <th>Name</th>
                            <th class="text-center">Qty</th>
                            <th class="text-center">Price</th>
                            <th class="text-center">Discount</th>
                            <th class="text-center" style="border-top-right-radius: .5rem">Sub Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($carts as $cart)
                            <tr wire:key="cart-{{ $cart['id'] }}">
                                <td style="font-weight: 500">{{ $cart['code'] }}</td>
                                {{-- <td data-bs-toggle="modal" data-bs-target="#modalCart" style="cursor: pointer"> --}}
                                <td>
                                    {{ $cart['name'] }}</td>
                                <td width="68px" class="stop-propagation text-center">
                                    {{ $cart['qty'] }}
                                </td>
                                <td class="text-center">
                                    {{ 'Rp ' . number_format($cart['nprice'], 0, ',', '.') }}
                                </td>
                                <td class="text-center">
                                    {{ 'Rp ' . number_format($cart['nprice'] - $cart['price'], 0, ',', '.') }}</td>
                                <td class="text-center">
                                    {{ 'Rp ' . number_format($cart['price'] * $cart['qty'], 0, ',', '.') }}</td>

                            </tr>
                        @empty
                            <tr class="text-center" width="100%">
                                <td colspan="6">
                                    Empty
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="d-flex justify-content-center align-items-center">
            <button type="button"
               data-bs-toggle="modal" 
                data-bs-target="#modalCancel" 
                class="button-try-red"
                >
                <div class="d-flex justify-content-center align-items-center gap-2">
                    <div class="text-white ">Cancel</div>
                    <h6 class="fst-italic"
                        style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; padding: 3px; fw-bold">
                        Esc</h6>
                </div>
                
            </button>
            <button type="button"
               data-bs-toggle="modal" 
               @if($data['overalPrice'] >= 0)
                data-bs-target="#modalNoMoney" 
                class="button-try"
                @else
                data-bs-target="#invoiceReturnModal" 
                class="button-try-red"
                @endif
                >
                <div class="d-flex justify-content-center align-items-center gap-2">
                    <div class="text-white ">Pay</div>
                    <h6 class="fst-italic"
                        style="color: #F6E9B2; border: 2px solid #F6E9B2; border-radius: 5px; padding: 3px; fw-bold">
                        F4</h6>
                </div>
                
            </button>
            
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalCancel" aria-hidden="true"
        aria-labelledby="modalCancelLabel2" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Cancel Return Sale</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="d-flex justify-content-center align-items-center"> Are you sure to
                        Cancel the Return Sale?
                    </h4>
                </div>
                <div class="modal-footer">
                    <button class="button-custom-success mr-auto" 
                    wire:click="toCancel"
                    @if($isButtonDisabled) disabled @endif>
                Yes
            </button>

                    <button class="button-custom-danger" data-bs-dismiss="modal" @if($isButtonDisabled) disabled @endif>No</button>
                </div>
            </div>
        </div>
    </div>
    {{-- <div wire:ignore.self class="modal fade" id="modalCart" tabindex="-1" aria-labelledby="modalCartLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCartLabel">Carts</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th class="text-center">#</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($carts as $cart)
                                <tr wire:key="cart-{{ $cart['id'] }}">
                                    <td>{{ $cart['code'] }}</td>
                                    <td>{{ $cart['name'] }}</td>
                                    <td>
                                        {{ 'Rp ' . number_format($cart['price'], 0, ',', '.') }}
                                    </td>
                                    <td width="68px" class="stop-propagation text-center">
                                        {{ $cart['qty'] }}
                                    </td>

                                    <td class="text-center">
                                        <button wire:click="deleteCart({{ $cart['id'] }})"
                                            class="badge button-custom-danger" type="button"
                                            {{ $cart['benefit'] == 'Free' || $cart['benefit'] == 'Cheapest' ? 'disabled' : '' }}>
                                            Delete
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr class="text-center" width="100%">
                                    <td colspan="6">
                                        Empty
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div> --}}

    <livewire:returnsale.inputreturn :item="$data"/>
</div>
