<div>
    <div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalNewItem" tabindex="-1"
        aria-labelledby="modalNewItemLabel" aria-hidden="true" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add New Item
                        <br>Saldo : {{ $overalPrice }}
                    </h5>
                    {{-- @dump(session('Promo-GWP-FreeItem' . auth()->user()->id))
                    @dump(session('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id)) --}}
                </div>
                <div class="modal-body">
                    <div class="col mb-3" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
                        <div class="form-group">
                            <label class="small text-muted mb-1">Kode Produk</label>
                            <div class="d-flex">
                                <input type="text" id="searchitem" class="form-control" wire:model.live="searchitem"
                                    placeholder="Type to search..." id="searchInputModal" autofocus autocomplete="off"
                                    @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($products) - 1 }})"
                                    @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                    x-on:keydown.enter="
                                if(selectedIndex == -1) {
                                    $wire.selectProductByName();
                                } else {
                                    $wire.selectProduct(selectedIndex);
                                    selectedIndex = -1; 
                                }">
                            </div>

                            @if ($selectedProduct === null && sizeof($products) > 0)
                                <div class="dropdown-menu d-block py-0" style="width: 770px">
                                    @foreach ($products as $index => $product)
                                        <div class="px-2 py-1 border-bottom"
                                            :class="{ 'bg-primary': selectedIndex === {{ $index }} }">
                                            <div class="d-flex flex-column ml-3">
                                                <button type="button"
                                                    wire:click="byClick('{{ $product->code }}')"
                                                    class="btn btn-link"
                                                    :class="{ 'text-white': selectedIndex === {{ $index }} }">
                                                    {{ $product->code }} || {{ $product->name }} ||
                                                    {{ $product->price }} || {{ $product->U_IDU_Brand }}
                                                </button>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                    <table class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th>Promo</th>
                                <th>Pack</th>
                                <th>Promo Tipe</th>
                                <th>Benefit</th>

                                <th class="text-center">#</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($carts as $index => $cart)
                                <tr>
                                    <td>{{ $cart['itemcode'] }}</td>
                                    <td>{{ $cart['itemname'] }}</td>
                                   
                                    <td>
                                        {{ 'Rp ' . number_format($cart['itemprice'], 0, ',', '.') }}
                                    </td>
                                    <td width="80px">
                                        <input class="form-control form-control-sm quantity-input" type="number"
                                            id="quantity-{{ $index }}"
                                            wire:model="carts.{{ $index }}.itemqty"
                                            wire:change="updateItemQty('{{ $index }}', $event.target.value)"
                                            >
                                    </td>
                                    <td>{{ $cart['promo'] }}</td>
                                    <td>{{ $cart['pack'] }}</td>
                                    <td>{{ $cart['promotipe'] }}</td>
                                    <td>{{ $cart['benefit'] }}</td>

                                    <td class="text-center">
                                        <button wire:click="deleteFromCarts({{ $index }})"
                                            class="badge button-custom-danger" type="button">
                                            Delete
                                        </button>
                                    </td>
                                </tr>
                            @empty
                                <tr class="text-center" width="100%">
                                    <td colspan="9">
                                        Empty
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                    <div class="modal-footer">
                        <button type="button" id="saveButton" class="custom-button1" data-bs-dismiss="modal"
                            wire:click="save" wire:keydown.enter="save"
                            @if (!$selectedProduct) disabled @endif>Save</button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <livewire:returnsale.select-discount />
</div>

