<div>
    <div wire:ignore.self class="modal fade" id="invoiceReturnModal" tabindex="-1" aria-labelledby="invoiceModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="form-group" wire:key="{{ $refreshKey }}">
                        <div x-data="{ isInputGroupVisible: false }">
                            <div class="form-check" @click="isInputGroupVisible = !isInputGroupVisible"
                                data-toggle="tooltip" title="Click to show/hide voucher">
                                <h5 class="modal-title" style="cursor: pointer;">Payment</h5>
                            </div>
                            <div x-show="isInputGroupVisible" class="form-check">
                                <div class="input-group">
                                    <input type="text" class="form-control" wire:model.live="searchvoucher">
                                    <button class="custom-button1" wire:click="applyVoucher">Apply</button>
                                </div>
                                <span class="text-danger">{{ $message }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="form-group d-flex justify-content-center align-items-center">
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="cashOption" name="paymentOption"
                                value="cash" wire:model.live="paymentOption">
                            <label class="form-check-label" for="cashOption">Cash</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="qrisOption" name="paymentOption"
                                value="qris" wire:model.live="paymentOption">
                            <label class="form-check-label" for="qrisOption">QRIS</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="cardOption" name="paymentOption"
                                value="card" wire:model.live="paymentOption">
                            <label class="form-check-label" for="cardOption">Card</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" class="form-check-input" id="multiOption" name="paymentOption"
                                value="multi" wire:model.live="paymentOption">
                            <label class="form-check-label" for="multiOption">Multi</label>
                        </div>
                        @error('paymentOption')
                            <small class="text-danger d-block mt-1"> {{ $message }}</small>
                        @enderror
                    </div>
                    <hr>
                    @if ($paymentOption !== 'card' && $paymentOption !== 'multi')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span id="totalAmount">Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        @if ($paymentOption === 'cash')
                            <div class="form-group">
                                <label for="payment">Payment:</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp.</span>
                                    <input type="text" id="paymentInput" class="form-control"
                                        wire:model.live.debounce.500ms="payment" x-mask:dynamic="$money($input, ',')"
                                        autofocus>
                                </div>
                            </div>
                            <div class="form-group mt-2">
                                <label class="fs-3" for="change">Change:</label>
                                <span class="fs-3">Rp. </span><span class="fw-bold text-success fs-3"
                                    wire:model="change">{{ number_format($change, 0, ',', '.') }}</span>
                            </div>
                        @endif
                    @endif
                    @if ($paymentOption === 'card')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span>Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        <div class="form-group">
                            <label for="namaBank">Nama Bank</label>
                            <div class="input-group">
                                <select class="input-group-text" id="type" wire:model.live="type">
                                    <option value="Credit">Credit</option>
                                    <option value="Debit">Debit</option>
                                </select>
                                <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                    <option value="BCA">BCA (Bank Central Asia)</option>
                                    <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                    <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                    <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaPemegangKartu">Nama Pemegang Kartu</label>
                            <input type="text" class="form-control" id="namaPemegangKartu"
                                wire:model.live="namaPemegangKartu">
                        </div>
                        <div class="form-group">
                            <label for="nomorKartu">Nomor Kartu</label>
                            <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                            @error('nomorKartu')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif
                    @if ($paymentOption === 'multi')
                        <div class="form-group mt-2">
                            <label for="totalAmount">Total Amount:</label>
                            <span>Rp. {{ number_format($totalAmount, 0, ',', '.') }}</span>
                        </div>
                        <div class="form-group mt-2">
                            <label for="cash">Cash : </label>
                            <div class="input-group">
                                <span class="input-group-text">Rp.</span>
                                <input type="text" id="cashInput" class="form-control"
                                    wire:model.live.debounce.500ms="cash" x-mask:dynamic="$money($input, ',')">
                            </div>
                            <div class="">
                                <label for="totalAmount">Transfer :</label>
                                <span>Rp. </span><span
                                    class="fw-bold">{{ number_format($transfer, 0, ',', '.') }}</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaBank">Nama Bank</label>
                            <div class="input-group">
                                <select class="input-group-text" id="type" wire:model.live="type">
                                    <option value="Credit">Credit</option>
                                    <option value="Debit">Debit</option>
                                </select>
                                <select class="form-control" id="namaBank" wire:model.live="namaBank">
                                    <option value="BCA">BCA (Bank Central Asia)</option>
                                    <option value="BRI">BRI (Bank Rakyat Indonesia)</option>
                                    <option value="BNI">BNI (Bank Negara Indonesia)</option>
                                    <option value="Mandiri">Mandiri (Bank Mandiri)</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="namaPemegangKartu">Nama Pemegang Kartu</label>
                            <input type="text" class="form-control" id="namaPemegangKartu"
                                wire:model.live="namaPemegangKartu">
                        </div>
                        <div class="form-group">
                            <label for="nomorKartu">Nomor Kartu</label>
                            <input type="text" class="form-control" id="nomorKartu" wire:model.live="nomorKartu">
                            @error('nomorKartu')
                                <small class="text-danger d-block mt-1"> {{ $message }}</small>
                            @enderror
                        </div>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="custom-button1" wire:click="storewithmoney">Save</button>
                </div>
            </div>
        </div>
    </div>
    <div wire:ignore.self class="modal fade" id="modalNoMoney" aria-hidden="true" aria-labelledby="modalNoMoneyLabel2"
        tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSignLabel">Save Return Sale</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 class="d-flex justify-content-center align-items-center"> Are you sure to
                        Save the Return Sale?
                    </h4>
                </div>
                <div class="modal-footer">
                    <button class="button-custom-success mr-auto" data-bs-dismiss="modal" wire:click="store">
                        Yes
                    </button>

                    <button class="button-custom-danger" data-bs-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function updateChangeUI(changeValue) {
        const changeElement = document.querySelector('.change'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    function updateChangeTransfer(changeValue) {
        const changeElement = document.querySelector('.transfer'); // Get the element by class
        if (changeElement) {
            const formattedValue = new Intl.NumberFormat('id-ID').format(changeValue);
            changeElement.textContent = formattedValue; // Update the text content of the element
        }
    }

    const paymentInput = document.getElementById('paymentInput');
    const cashInput = document.getElementById('cashInput');
    const totalAmountElement = document.getElementById('totalAmount');

    function extractNumericValue(element) {
        if (element) {
            const numericValue = parseFloat(element.textContent.replace(/[^\d]/g, ''));
            return isNaN(numericValue) ? 0 : numericValue;
        }
        return 0;
    }

    const totalAmount = extractNumericValue(totalAmountElement);

    function calculateChange() {
        let inputValue = parseFloat(paymentInput.value.replace(/\./g, ''));

        if (!isNaN(inputValue)) {
            const change = inputValue - totalAmount;
            updateChangeUI(change);
        }
    }

    paymentInput.addEventListener('input', calculateChange);
    calculateChange();
</script>
