<div class="card">
    <div class="card-body">
        <div class="form-group row">
            <div class="col-md-4">
                <label for="startDate">Start Date</label>
                <input type="date" class="form-control" id="startDate" wire:model="startDate">
            </div>
            <div class="col-md-4">
                <label for="endDate">End Date</label>
                <input type="date" class="form-control" id="endDate" wire:model="endDate">
            </div>
            <div class="col-md-4 mt-4">
                <button type="button" id="filterBtn" wire:click="filterInvoices" class="custom-button1 mb-2" disabled>Filter</button>
                <button type="button" id="clearBtn" wire:click="clearFilter" class="button-custom-danger mb-2" disabled>Clear Filter</button>
            </div>

        </div>

        <div class="col-md-4 mt-2">
            <button type="button" wire:click="sapGetTrans" class="custom-button1 mb-2">Get SAP Trans</button>
            <button type="button" wire:click="exportExcel" class="custom-button1 mb-2">Export Excel</button>
            <button type="button" wire:click="exportARInvoiceDetail" class="custom-button1 mb-2">Export AR</button>
            <button type="button" wire:click="exportARItemDetail" class="custom-button1 mb-2">Export AR Detail</button>
            <button type="button" data-bs-toggle="modal" data-bs-target="#modalSyncAll" class="custom-button1 mb-2">Sync All</button>
        </div>
        <table>
            <thead>
                <tr></tr>
            </thead>
            <tbody>
                <td></td>
            </tbody>
        </table>
        <div wire:ignore.self>
            <table id="example" class="table table-striped mt-2" style="width:100%">
                <thead>
                    <tr>
                        <th>Invoice</th>
                        <th>Tanggal</th>
                        <th>Jam</th>
                        <th>User</th>
                        <th>Staff</th>
                        <th>Qty</th>
                        <th>Sub Total</th>
                        <th>Discount</th>
                        <th>Grand Total</th>
                        <th>Cash</th>
                        <th>Card</th>
                        <th>Sync</th>
                        <th>#</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                    $totalCash = 0;
                    $totalTransfer = 0;
                    $totalSubtotalQrisCash = 0;
                    $totalSubtotalCard = 0;
                    @endphp
    
                    @foreach ($invoices as $invoice)
                    <tr>
    
                        <td><button class="badge bg-info text-black" data-bs-target="#modalDetail{{ $invoice->no }}" data-bs-toggle="modal">{{ $invoice->no }}</button></td>
                        <td>{{ $invoice->created_at->format('d/m/y') }}</td>
                        <td>{{ $invoice->created_at->format('H:i') }}</td>
                        <td>{{ $invoice->user->name }}</td>
                        <td>{{ $invoice->sales_name }}</td>
                        <td>{{ $invoice->qty }}</td>
                        <td>Rp. {{ number_format($invoice->subtotal, 0, ',', '.') }}</td>
                        <td>Rp. {{ number_format($invoice->discount, 0, ',', '.') }}</td>
                        <td>Rp. {{ number_format($invoice->grandtotal, 0, ',', '.') }}</td>
    
                        @if ($invoice->payment === 'Multi')
                        @php
                        $totalCash += $invoice->cash;
                        $totalSubtotalCard += $invoice->transfer;
                        @endphp
                        <td>Rp. {{ number_format($invoice->cash, 0, ',', '.') }}</td>
                        <td>Rp. {{ number_format($invoice->transfer, 0, ',', '.') }}</td>
                        @elseif ($invoice->payment === 'Cash')
                        @php
                        $totalCash += $invoice->grandtotal;
                        @endphp
                        <td>Rp. {{ number_format($invoice->grandtotal, 0, ',', '.') }}</td>
                        <td>Rp. 0</td>
                        @elseif ($invoice->payment === 'Qris')
                        @php
                        $totalSubtotalCard += $invoice->grandtotal;
                        @endphp
                        <td>Rp. 0</td>
                        <td>Rp. {{ number_format($invoice->grandtotal, 0, ',', '.') }}</td>
                        @elseif ($invoice->payment === 'Card')
                        @php
                        $totalSubtotalCard += $invoice->grandtotal;
                        @endphp
                        <td>Rp. 0</td>
                        <td>Rp. {{ number_format($invoice->grandtotal, 0, ',', '.') }}</td>
                        @else
                        {{-- mz --}}
                        <td>Rp. 0</td>
                        <td>Rp. 0</td>
                        @endif
                        <td>
                            @if($invoice->sync == 'N')
                            <button class="button-custom-danger badge" data-bs-toggle="modal" data-bs-target="#modalSync{{ $invoice->no }}">Not Sync</button>
                            @else
                            <button class="button-custom-success badge">Sync</button>
                            @endif
                        </td>
                        <td>
                            <button class="custom-button1 badge" data-bs-toggle="modal" data-bs-target="#modalPrint{{ $invoice->no }}">Print</button>
                        </td>
                    </tr>
    
                    <div class="modal fade" id="modalPrint{{ $invoice->no }}" tabindex="-1" aria-labelledby="modalPrintLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="modalPrintLabel">Print Invoice</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Are you sure want Print Receipt <span class="fw-bold"> {{ $invoice->no }} </span> ?</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="button-custom-danger" data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="custom-button1" data-bs-dismiss="modal" wire:click="print('{{ $invoice->no }}')">Print</button>
                                </div>
                            </div>
                        </div>
                    </div>
    
                    <div wire:ignore.self class="modal fade" id="modalSync{{ $invoice->no }}" tabindex="-1" aria-labelledby="modalSyncLabel" aria-hidden="true" data-bs-backdrop="static">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="modalSyncLabel">Sync Invoice</h5>
                                </div>
                                <div class="modal-body">
                                    <p>Are you sure want Sync the Receipt <span class="fw-bold"> {{ $invoice->no }} </span> ?</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" id="closeSync" class="button-custom-danger" data-bs-dismiss="modal">Close</button>
                                    <button type="button" id="syncButton" class="custom-button1" wire:click="sync('{{ $invoice->no }}')">Sync</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
    
                </tbody>
            </table>
        </div>

        <div wire:ignore.self>
        <table id="example" class="table table-striped mt-2" style="width:100%">
            <thead>
                <tr>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th>Total Struk</th>
                    <th>Qty</th>
                    <th>Cash</th>
                    <th>Card</th>
                    <th>Sub Total</th>
                    <th>Discount</th>
                    <th>Grand Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td colspan="5">Total</td>
                    <td></td>
                    <td>{{ $invoices->count() }}</td>
                    <td>{{ $invoices->sum('qty') }}</td>
                    <td>Rp. {{ number_format($totalCash, 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format($totalSubtotalCard, 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format($invoices->sum('subtotal'), 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format($invoices->sum('discount'), 0, ',', '.') }}</td>

                    <td>Rp. {{ number_format($invoices->sum('grandtotal'), 0, ',', '.') }}</td>
                </tr>

            </tbody>
        </table>
        </div>
    </div>
    @foreach ($invoices as $invoice)
    <div class="modal fade modal-xl" id="modalDetail{{ $invoice->no }}" aria-hidden="true" aria-labelledby="modalDetailLabel2" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalDetailLabel2">Detail Invoice - {{ $invoice->no }}</h5>
          <button class="mx-2 button-custom-success badge" data-bs-target="#modalDetail" data-bs-toggle="modal" data-bs-dismiss="modal" wire:click="exportExcelDetail('{{ $invoice->no }}')" >
            Export  
        </button>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <button class="custom-button1" data-bs-target="#modalDetail" data-bs-toggle="modal" data-bs-dismiss="modal">Back</button>
          <table class="table table-striped" style="width:100%">
            <thead>
                <tr> 
                    <th style="text-align: center">Tanggal</th>
                    <th style="text-align: center">Staff</th>
                    <th style="text-align: center">Member</th>
                    <th style="text-align: center">Item Code</th>
                    <th style="text-align: center">Item Barcode</th>
                    <th style="text-align: center">Item Name</th>
                    <th style="text-align: center">Qty</th>
                    <th style="text-align: center">Price</th>
                    <th style="text-align: center">Disc</th>
                    <th style="text-align: center">Total Disc</th>
                    <th style="text-align: center">Sub Total</th>
                    <th style="text-align: center">Grand Total</th>
                </tr>
            </thead>
            <tbody>
            
            @foreach ($invoice->detailInvoices as $invoice)
                <tr>
                    <td>{{ $invoice->created_at->format('d/m/y') }}</td>
                    <td>{{ $invoice->sales->name }}</td>
                    @if($invoice->id_member)
                    <td>{{ $invoice->member->name }}</td>
                    @else
                    <td> - </td>
                    @endif
                    <td>`{{ $invoice->item->code }}`</td>
                    <td>`{{ $invoice->item->barcode }}`</td>
                    <td>{{ $invoice->item->name }}</td>
                    <td>{{ $invoice->qty }}</td>
                    <td>Rp. {{ number_format($invoice->nprice, 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format($invoice->nprice - $invoice->price, 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format(($invoice->nprice - $invoice->price) * $invoice->qty, 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format($invoice->nprice * $invoice->qty, 0, ',', '.') }}</td>
                    <td>Rp. {{ number_format($invoice->total_price, 0, ',', '.') }}</td>
                    
                  </tr>
            @endforeach
            </tbody>
        </table>
        </div>
      </div>
    </div>
</div>  
@endforeach
<livewire:report.syncall />

</div>


@livewireScripts
<script>
    Livewire.on('syncCompletedBrowser', () => {
        let closeButton = document.getElementById('closeSync');
        if (closeButton) {
            closeButton.click();
        }
    });
    Livewire.on('syncCompletedBrowserAll', () => {
        let closeButton = document.getElementById('closeSyncAll');
        if (closeButton) {
            closeButton.click();
        }
    });

    Livewire.on('refreshBrowser', (params) => {
        window.location.href = '{{ route('report.reportinvoice') }}';
    });
    Livewire.on('refreshjs', (params) => {
            console.log('test');
            $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });

    document.addEventListener('livewire:load', function () {
        Livewire.on('refreshjs', (params) => {
            $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });
});
    document.addEventListener('livewire:load', function () {
        document.getElementById('syncButton').addEventListener('click', function() {
    this.disabled = true;
    document.getElementById('closeSync').disabled = true; // Disabling closeSync button

});
    });
    document.getElementById('syncButton').addEventListener('click', function() {
    this.disabled = true;
    document.getElementById('closeSync').disabled = true; // Disabling closeSync button

});
    const startDateInput = document.getElementById('startDate');
    const endDateInput = document.getElementById('endDate');
    const filterBtn = document.getElementById('filterBtn');
    const clearBtn = document.getElementById('clearBtn');

    startDateInput.addEventListener('input', toggleButtonsState);
    endDateInput.addEventListener('input', toggleButtonsState);

    function toggleButtonsState() {
        const startDate = startDateInput.value;
        const endDate = endDateInput.value;

        if (startDate && endDate) {
            filterBtn.removeAttribute('disabled');
            clearBtn.removeAttribute('disabled');
        } else {
            filterBtn.setAttribute('disabled', 'disabled');
            clearBtn.setAttribute('disabled', 'disabled');
        }
    };
</script>