<div>
    <div wire:ignore.self class="py-12">
        <div class="table-responsive table-item">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: 1rem">#</th>
                        @if ($items->isEmpty())
                    <tr>
                        <th scope="col">Empty</th>
                    </tr>
                @else
                    @foreach (array_keys((array) $items[0]) as $fieldName)
                        @if (strpos($fieldName, 'U_') === 0)
                            <th scope="col">{{ ucfirst(substr($fieldName, 2)) }}</th>
                        @else
                            <th scope="col">{{ ucfirst(__($fieldName)) }}</th>
                        @endif
                    @endforeach
                    @endif
                    </tr>
                </thead>

                <tbody class="small">
                    @foreach ($items as $key => $item)
                        <tr>
                            <th scope="row">{{ $key + 1 }}</th>
                            @foreach ((array) $item as $key => $value)
                                @if ($key == 'info')
                                    <td>
                                        @if ($value === 0)
                                            -
                                        @else
                                            <button data-bs-toggle="modal"
                                                data-bs-target="#exampleModal{{ $item->code }}"
                                                class="btn btn-sm badge button-custom-success">PROMO</button>
                                        @endif
                                    </td>
                                @else
                                    <td>{{ $value }}</td>
                                @endif
                            @endforeach
                        </tr>
                        <div wire:ignore.self class="modal fade" id="exampleModal{{ $item->code }}" tabindex="-1"
                            aria-labelledby="exampleModalLabel" aria-hidden="true" data-bs-backdrop="static"
                            data-bs-keyboard="false">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Promo</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            wire:click="clearPromo" aria-label="Close"></button>
                                    </div>
                                    @if ($promoitem)
                                        <div class="modal-body">
                                            <ul>
                                                @foreach ($promoitem as $item)
                                                    <li>{{ $item->name }} || Periode : {{ $item->from_date }} -
                                                        {{ $item->to_date }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @else
                                    <div class="modal-body text-center">
                                        <button type="button" class="custom-button1 text-center"
                                        wire:click="dispatchToDetailItem('{{ $item->code }}')">Check</button>
                                    </div>
                                        
                                    @endif

                                    <div class="modal-footer">
                                        <button type="button" class="custom-button1" data-bs-dismiss="modal"
                                            wire:click="clearPromo">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div wire:ignore.self>
            <table id="example" class="table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>
                        <th scope="col"></th>

                        <th style="text-align: center;" scope="col">{{ __('Total Qty') }}</th>
                    </tr>
                </thead>

                <tbody class="small">

                    <tr>
                        <td colspan="6">Total</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>

                        <td style="text-align: center;">{{ number_format($items->sum('qty'), 0, ',', ',') }}</td>
                    </tr>

                </tbody>
            </table>
        </div>
    </div>
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });
</script>
