<div>
    <div class="page-content">
        <nav class="page-breadcrumb">
            <div class="d-flex justify-content-between align-items-center breadcrumb-it-in">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a livewire:navigate href="/">{{ __('Main') }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">
                        {{ __('Items') }}
                    </li>
                </ol>

                <div>
                    @if($isloadingtrans)
                    <button wire:click="clickGetItem" wire:loading.attr="disabled" wire:target="sapGetItem" type="button" class="custom-button1 btn-sm ml-4" disabled>
                        {{ __('Sync SAP Item') }}
                    </button>
                    <button type="button" wire:click="syncPromo" class="custom-button1 btn-sm ml-4" disabled>{{ __('Sync Promo Item') }}</button>

                    <button type="button" wire:click="clickGetTrans" wire:loading.attr="disabled" wire:target="sapGetTrans" class="custom-button1 btn-sm ml-4" disabled>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    </button>
                    @endif
                    @if($isloadingitem)
                    <button wire:click="clickGetItem" wire:loading.attr="disabled" wire:target="sapGetItem" type="button" class="custom-button1 btn-sm ml-4" disabled>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    </button>
                    <button type="button" wire:click="syncPromo" class="custom-button1 btn-sm ml-4" disabled>{{ __('Sync Promo Item') }}</button>

                    <button type="button" wire:click="clickGetTrans" wire:loading.attr="disabled" wire:target="sapGetTrans" class="custom-button1 btn-sm ml-4" disabled>{{ __('Sync SAP Transaction') }}</button>
                    @endif
                    @if($isloadingpromo)
                    <button wire:click="clickGetItem" wire:loading.attr="disabled" wire:target="sapGetItem" type="button" class="custom-button1 btn-sm ml-4" disabled>
                        {{ __('Sync SAP Item') }}
                    </button>
                    <button wire:click="clickGetItem" wire:loading.attr="disabled" wire:target="sapGetItem" type="button" class="custom-button1 btn-sm ml-4" disabled>
                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span id="innerSpan">Loading . . .</span>
                    </button>

                    <button type="button" wire:click="clickGetTrans" wire:loading.attr="disabled" wire:target="sapGetTrans" class="custom-button1 btn-sm ml-4" disabled>{{ __('Sync SAP Transaction') }}</button>
                    @endif
                    
                    @if(!$isloadingtrans && !$isloadingitem && !$isloadingpromo)
                    <button wire:click="clickGetItem" wire:loading.attr="disabled" wire:target="sapGetItem" type="button" class="custom-button1 btn-sm ml-4">{{ __('Sync SAP Item') }}</button>
                    <button type="button" wire:click="clickPromo" class="custom-button1 btn-sm ml-4">{{ __('Sync Promo Item') }}</button>
                    <button type="button" data-bs-toggle="modal" data-bs-target="#modalGetSAP" class="custom-button1 btn-sm ml-4">{{ __('Sync SAP Transaction') }}</button>

                    @endif
                </div>
            </div>
        </nav>

        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="">
                    <div class="card-body mb-3">
                        <div class="align-items-center card-body justify-content-between small">
                            {{-- <h6 class="card-title ">{{ __('Items') }}</h6> --}}
                            <div class="form-group row">
                                <div class="col-md-2">
                                    <label for="typeInvoice">Filter By</label>
                                    <select class="form-select" wire:model.live="type" id="type" style="border-radius: 1rem">
                                        <option value="Barcode">Barcode</option>
                                        <option value="Code">Code</option>
                                        <option value="Name">Name</option>
                                      </select>
                                </div>
                                <div class="col-md-2">
                                    <label for="input"></label>
                                    <input type="text" class="form-control" wire:model.live="inputfilter" style="border-radius: 1rem">
                                </div>
                                <div class="col-md-2 py-3 mt-1">
                                    @if($isloadingsearch)
                                    <button wire:click="filterItem" wire:loading.attr="disabled" wire:target="filterItem" type="button" class="custom-button1 mb-2" disabled>
                                        <span id="loadingSpinner2" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                        <span id="innerSpan">Loading . . .</span>
                                    </button>
                                    @else
                                    <button type="button" id="filterBtn" class="custom-button1 mb-2" @if(!$inputfilter) disabled @else wire:click="firstClick" @endif>Filter</button>
                                    @endif
                                </div>
                            </div>
                            
                        </div>
                        <livewire:pos.item.get-s-a-p-trans />

                        @if($isFilter)
                        <livewire:pos.item.item-table :item="$item"/>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    @livewireScripts
    <script>
        Livewire.on('refreshjs', (params) => {
            $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });


        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            $('#table').DataTable({
                "bDestroy": true
            });
        });

        document.addEventListener('livewire:navigated', () => {
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                $('#table').DataTable({
                    "bDestroy": true
                });
            });
        });
    </script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
</div>