<div wire:ignore.self>
    <div class="py-12">
        <div class="table-responsive">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: .5rem">#</th>
                        <th scope="col">{{ __('Action') }}</th>
                        <th scope="col">{{ __('From') }}</th>
                        <th scope="col">{{ __('No') }}</th>
                        <th scope="col">{{ __('Date') }}</th>
                        <th scope="col">{{ __('Remark') }}</th>
                        <th scope="col">{{ __('Total Qty') }}</th>
                        <th scope="col">{{ __('Status') }}</th>
                        <th class="text-center" scope="col">{{ __('Sign') }}</th>
                        <th class="text-center" scope="col" style="border-top-right-radius: .5rem">
                            {{ __('Sync') }}</th>



                    </tr>
                </thead>

                <tbody class="small">
                    @forelse($its as $key => $it)
                        <tr wire:key="{{ $it->no }}">
                            <th scope="col">{{ $key + 1 }}</td>
                            <td>
                                <a href="/it_req/view/{{ $it->no }}" class="custom-button1 content-end"
                                    style="padding: 2.5px 5px; font-size: 10px;">
                                    Detail
                                </a>
                            </td>
                            <td>{{ $it->whsFrom->name }}</td>
                            <td>{{ $it->no }}</td>
                            <td>{{ $it->date }}</td>
                            <td>{{ $it->comments }}</td>
                            <td style="text-align: right; padding-right: 20px">{{ $it->details_sum_qty }}</td>
                            <td>
                                @if ($it->status == 'Not Checked')
                                    <span class="text-danger">Not Checked</span>
                                @elseif($it->status == 'Same')
                                    <span class="text-success">Same</span>
                                @elseif($it->status == 'Difference')
                                    <span class="text-warning">Difference</span>
                                @endif
                            </td>
                            <td class="">
                                @if ($it->sign == 'Y')
                                    <button class="btn-badge btn-sm button-custom-success"
                                        style="border-radius: .5rem; font-size: 10px; padding-inline: 4px; padding-block: 2px"> Signed
                                    </button>
                                @else
                                    <button class="btn-badge btn-sm button-custom-danger"
                                        style="border-radius: .5rem; font-size: 10px; padding-inline: 4px; padding-block: 2px"> Not Signed
                                    </button>
                                @endif
                            </td>
                            <td class="justify-content-center">
                                @if ($it->status == 'Difference' && $it->sign == 'Y')
                                    {{-- <button class="btn-badge btn-sm btn-warning"
                                        data-bs-target="#modalEmail{{ $it->no }}" data-bs-toggle="modal"
                                        style="font-size: 10px;"> Email
                                    </button> --}}
                                @elseif ($it->status == 'Same' && $it->sign == 'Y')
                                    @if ($it->sync == 'N')
                                        @if ($isloading)
                                            <button class="btn-badge btn-sm button-custom-danger"
                                                style="border-radius: .5rem; font-size: 10px; padding-inline: 4px; padding-block: 2px" disabled> <span
                                                    id="loadingSpinner2" class="spinner-border spinner-border-sm"
                                                    role="status" aria-hidden="true"></span>
                                                <span id="innerSpan">Loading . . .</span>
                                            </button>
                                        @else
                                            <button class="btn-badge btn-sm button-custom-danger"
                                                style="border-radius: .5rem; font-size: 10px; padding-inline: 4px; padding-block: 2px"
                                                data-bs-target="#modalSync{{ $it->no }}" data-bs-toggle="modal">
                                                Not
                                                Sync
                                            </button>
                                        @endif
                                    @else
                                        <button class="btn-badge btn-sm button-custom-success"
                                            style="border-radius: .5rem; font-size: 10px; padding-inline: 4px; padding-block: 2px" disabled>
                                            Sync
                                        </button>
                                    @endif
                                @else
                                    <span class="badge"> - </span>
                                @endif
                            </td>

                        </tr>
                        <div class="modal fade" id="modalEmail{{ $it->no }}" aria-hidden="true"
                            aria-labelledby="modalEmailLabel2" tabindex="-1">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="modalSignLabel">Send Email IT Request</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <h4 class="d-flex justify-content-center align-items-center"> Are you sure to
                                            Send email It Request?
                                        </h4>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="button-custom-success mr-auto"
                                            wire:click="sendEmailItReq('{{ $it->no }}')"
                                            data-bs-dismiss="modal">Send</button>

                                        <button class="button-custom-danger" data-bs-target="#modalSign"
                                            data-bs-toggle="modal" data-bs-dismiss="modal">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="modalSync{{ $it->no }}" aria-hidden="true"
                            aria-labelledby="modalSyncLabel2" tabindex="-1">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="modalSignLabel">Sync IT Request</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <h4 class="d-flex justify-content-center align-items-center"> Are you sure to
                                            Sync the It Request?
                                        </h4>
                                        <h4 class="d-flex justify-content-center align-items-center">It's cant be
                                            Revert. </h4>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="button-custom-success mr-auto"
                                            wire:click="firstClick('{{ $it->no }}')"
                                            data-bs-dismiss="modal">Send</button>

                                        <button class="button-custom-danger" data-bs-target="#modalSign"
                                            data-bs-toggle="modal" data-bs-dismiss="modal">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                    @endforelse
                </tbody>
            </table>
        </div>
        <table id="example" class="table dataTables_wrapper dt-bootstrap5 mt-2" style="width:100%; ">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col" style="text-align: right;">{{ __('Total Qty') }}</th>

                </tr>
            </thead>

            <tbody class="small">

                <tr>
                    <td>Total</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>

                    <td style="text-align: right;">{{ number_format($totalSumQty, 0, ',', ',') }}</td>

                </tr>

            </tbody>
        </table>
    </div>
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });
</script>
