<div wire:ignore.self>
    <div class="py-12">
        <div class="table-responsive">
            <table id="example" class="my-table dataTables_wrapper dt-bootstrap5" style="width:100%; ">
                <thead>
                    <tr>
                        <th scope="col" style="border-top-left-radius: .5rem">#</th>
                        <th scope="col">{{ __('Action') }}</th>
                        <th scope="col">{{ __('To') }}</th>
                        <th scope="col">{{ __('No') }}</th>
                        @if($selectedOption != 'Default')
                        <th scope="col">{{ __('Entry') }}</th>
                        @endif
                        <th scope="col">{{ __('Date') }}</th>
                        <th scope="col">{{ __('Remark') }}</th>
                        <th scope="col">{{ __('Total Qty') }}</th>
                        <th class="text-center" scope="col" style="border-top-right-radius: .5rem">
                            {{ __('Sync') }}</th>



                    </tr>
                </thead>

                <tbody class="small">
                    @forelse($its as $key => $it)
                        <tr wire:key="{{ $it->no }}">
                            <th scope="col">{{ $key + 1 }}</td>
                            <td>
                                <a href="/it_reqout/view/{{ $it->no }}" class="custom-button1 content-end"
                                    style="padding: 2.5px 5px; font-size: 10px;">
                                    Detail
                                </a>
                            </td>
                            <td>{{ $it->whsTo->name }}</td>
                            <td>{{ $it->no }}</td>
                            @if($selectedOption != 'Default')
                                <td>{{ $it->entry ?? '-' }}</td>
                            @endif
                            <td>{{ $it->date }}</td>
                            <td>{{ $it->comments }}</td>
                            <td style="text-align: left; padding-right: 20px">{{ $it->details_sum_qty_send }}</td>

                            <td class="justify-content-center">
                                @if ($it->sync == 'N')
                                    <button class="btn-sm badge button-custom-danger"
                                        onclick="syncITReqOut('{{ $it->id }}', '{{ $it->no }}')"
                                        @if($disableButton) disabled @endif
                                        >
                                        Not Sync</button>
                                @else
                                    <button class="btn-sm badge button-custom-success" disabled>
                                        Sync</button>
                                @endif
                                <button class="btn-sm badge button-custom-primary"
                                    onclick="printITReqOut('{{ $it->id }}', '{{ $it->no }}')"
                                    @if($disableButton) disabled @endif

                                    >Print</button>
                            </td>

                        </tr>

                        <div class="modal fade" id="modalSync{{ $it->no }}" aria-hidden="true"
                            aria-labelledby="modalSyncLabel2" tabindex="-1">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="modalSignLabel">Sync IT Request</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <h4 class="d-flex justify-content-center align-items-center"> Are you sure to
                                            Sync the It Request?
                                        </h4>
                                        <h4 class="d-flex justify-content-center align-items-center">It's cant be
                                            Revert. </h4>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="button-custom-success mr-auto"
                                            wire:click="firstClick('{{ $it->no }}')"
                                            data-bs-dismiss="modal">Send</button>

                                        <button class="button-custom-danger" data-bs-target="#modalSign"
                                            data-bs-toggle="modal" data-bs-dismiss="modal">Back</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                    @endforelse
                </tbody>
            </table>
        </div>
        <table id="example" class="table dataTables_wrapper dt-bootstrap5 mt-2" style="width:100%; ">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col"></th>
                    <th scope="col" style="text-align: right;">{{ __('Total Qty') }}</th>

                </tr>
            </thead>

            <tbody class="small">

                <tr>
                    <td>Total</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>

                    <td style="text-align: right;">{{ number_format($totalSumQty, 0, ',', ',') }}</td>

                </tr>

            </tbody>
        </table>
    </div>
</div>
@livewireScripts
<script>
    Livewire.on('refreshjs', (params) => {
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode = 'none';
            var table = $('#example').DataTable();

            $(document).keypress(function(e) {
                // Check if the pressed key is '/' (forward slash)
                if (e.which == 47) {
                    e.preventDefault(); // Prevent default action
                    // Focus on the search input field of the DataTable
                    $('.dataTables_filter input').focus();
                }
                // Check if the pressed key is '.' (period) for next page
                else if (e.which == 46) {
                    e.preventDefault(); // Prevent default action
                    table.page('next').draw('page');
                }
                // Check if the pressed key is ',' (comma) for previous page
                else if (e.which == 44) {
                    e.preventDefault(); // Prevent default action
                    table.page('previous').draw('page');
                }
            });
        });
    });

    function syncITReqOut(id, no) {
        Livewire.dispatch('toSyncITReqOut', {
            no: no,
        });
    }

    function printITReqOut(id, no) {
        window.open('/it_reqout/print/' + no, '_blank');
    }
</script>
