<div wire:ignore.self class="modal fade" data-bs-backdrop="static" id="modalCheapest" tabindex="-1"
    aria-labelledby="modalCheapestLabel" aria-hidden="true" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Cheapest Item</h5>
            </div>
            <div class="modal-body">
                <div class="col mb-3" x-data="{ selectedIndex: null }" x-init="selectedIndex = -1">
                    <div class="form-group">
                        <label class="small text-muted mb-1">Kode Produk</label>
                        <div class="d-flex">
                            <input type="text" class="form-control" wire:model.live="searchcheapest"
                                placeholder="Type to search..."
                                id="searchInputModal" autofocus autocomplete="off"
                                @keydown.arrow-down.prevent="selectedIndex = Math.min(selectedIndex + 1, {{ sizeof($products) - 1 }})"
                                @keydown.arrow-up.prevent="selectedIndex = Math.max(selectedIndex - 1, -1)"
                                x-on:keydown.enter="
                                if(selectedIndex == -1) {
                                    $wire.selectProductByName();
                                } else {
                                    $wire.selectProduct(selectedIndex);
                                    selectedIndex = -1; 
                                }">
                        </div>

                        @if ($selectedProduct === null && sizeof($products) > 0)
                            <div class="dropdown-menu d-block py-0" style="width: 770px">
                                @foreach ($products as $index => $product)
                                <div class="px-2 py-1 border-bottom"
                                        :class="{ 'bg-primary': selectedIndex === {{ $index }} }">
                                        <div class="d-flex flex-column ml-3">
                                            <button type="button"
                                                wire:click="selectProductByClick('{{ $product->code }}')"
                                                class="btn btn-link"
                                                :class="{ 'text-white': selectedIndex === {{ $index }} }">
                                                {{ $product->code }} || {{ $product->name }}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>

                <table class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Code</th>
                            <th>Name</th>
                            <th>Price</th>
                            <th>Qty</th>
                            <th class="text-center">#</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($carts as $index => $cart)
                            <tr>
                                <td>{{ $cart['id'] }}</td>
                                <td>{{ $cart['itemcode'] }}</td>
                                <td>{{ $cart['itemname'] }}</td>
                               
                                <td>
                                    {{ 'Rp ' . number_format($cart['itemprice'], 0, ',', '.') }}
                                </td>
                                <td width="80px">
                                    <input class="form-control form-control-sm quantity-input" type="number"
                                        id="quantity-{{ $index }}"
                                        wire:model="carts.{{ $index }}.itemqty"
                                        wire:change="updateItemQty('{{ $index }}', $event.target.value)"
                                        >
                                </td>
                                <td class="text-center">
                                    <button wire:click="deleteFromCarts({{ $index }})"
                                        class="badge button-custom-danger" type="button">
                                        Delete
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr class="text-center" width="100%">
                                <td colspan="6">
                                    Empty
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="modal-footer">
                    <button type="button" id="saveButton" class="custom-button1"
                        wire:click="save" wire:keydown.enter="save"
                        @if (!$carts) disabled @endif @if($isLimit) data-bs-dismiss="modal" @endif>Save</button>
                </div>
            </div>
        </div>
    </div>
