<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme="">

<head>
    <script>
        (function() {
            const storedTheme = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const theme = storedTheme || (prefersDark ? 'dark' : 'light');
            document.documentElement.setAttribute('data-bs-theme', theme);
        })();
    </script>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-192x192.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/android-chrome-512x512.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/apple-touch-icon.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-16x16.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon-32x32.png') }}" type="image/x-icon">
    <link rel="icon" href="{{ asset('assets/favicon/favicon.ico') }}" type="image/x-icon">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }} - Bestari Jaya</title>

    <link href="https://fastly.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    {{-- <link rel="stylesheet" href="{{ asset('assets/css/bootstrap-icons.css') }}"> --}}
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">
    <!-- Include Bootstrap 5 CSS -->
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet">

    <!-- Include DataTables Bootstrap 5 extension CSS -->
    <link href="{{ asset('assets/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">

    <style>
        .modal {
            backdrop-filter: blur(5px);
        }
    </style>
    @stack('styles')
    @livewireStyles
    <!-- Scripts -->
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
</head>

<body>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip({
                'placement': 'right'
            });
        });
    </script>

    <div id="app" class="app-cashier">

        <div class="w-full">

            <div class="d-flex ">
                <div class="sidebar py-5 text-white">
                    <div>
                        <div class="sidebar-icon">
                            <a class="navbar-brand" href="{{ url('/') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="home">
                                <img src="{{ asset('assets/home (2).png') }}">
                            </a>
                            {{-- <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                                <span class="navbar-toggler-icon"></span>
                            </button> --}}
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('welcome.*') ? 'active' : '' }}"
                                href="{{ route('welcome.dashboard') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="cashier">{{ __('') }}
                                <img src="{{ asset('assets/shopping-bag.png') }}">
                            </a>
                        </div>

                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('member.*') ? 'active' : '' }}"
                                href="{{ route('member.index') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="member">{{ __('') }}
                                <img src="{{ asset('assets/membership.png') }}">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('item') ? 'active' : '' }}"
                                href="{{ route('item') }}" data-toggle="tooltip" rel="tooltip" data-placement="right"
                                title="item">{{ __('') }}
                                <img src="{{ asset('assets/product (1).png') }}">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('opname') ? 'active' : '' }}"
                                href="{{ route('opname') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="opname">{{ __('') }}
                                <img src="{{ asset('assets/product.png') }}">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('activity-log') ? 'active' : '' }}"
                                href="{{ route('activity-log') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="activity log">{{ __('') }}
                                <img src="{{ asset('assets/time-management.png') }}">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('salesemp') ? 'active' : '' }}"
                                href="{{ route('salesemp') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="sales employees">{{ __('') }}
                                <img src="{{ asset('assets/employee.png') }}">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('it.itin') || request()->routeIs('it.itout') || request()->routeIs('it.itreq') || request()->routeIs('it.itreqout') ? 'active' : '' }}"
                                href="{{ route('it.itin') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="it">
                                <img src="{{ asset('assets/in-out.png') }}">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link dropdown-toggle {{ request()->routeIs('report.*') ? 'active' : '' }}"
                                href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                {{ __('') }}
                                <img src="{{ asset('assets/report.png') }}">
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" href="{{ route('report.reportinvoicereturnsale') }}"
                                        id="ddown-style">{{ __('Report Sale & Return Sale') }}</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="{{ route('report.reporttransactionmember') }}"
                                        id="ddown-style">{{ __('Member') }}</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="{{ route('report.voucher') }}"
                                        id="ddown-style">{{ __('Voucher') }}</a></li>
                            </ul>
                        </div>
                        <div class="sidebar-icon">
                            <a class="nav-link {{ request()->routeIs('synchronization') ? 'active' : '' }}"
                                href="{{ route('synchronization') }}" data-toggle="tooltip" rel="tooltip"
                                data-placement="right" title="synchronization">{{ __('') }}
                                <img src="{{ asset('assets/sync.png') }}">
                            </a>
                        </div>
                        <div class="sidebar-icon">
                            <button id="toggleThemeButton" class="bg-transparent" style="border: none;"
                                data-toggle="tooltip" rel="tooltip" data-placement="right" title="color mode"
                                height="25px" width="25px">
                                <i id="themeIcon" class="bi bi-moon-fill"></i>
                            </button>
                        </div>
                    </div>

                    <div>
                        <div class="sidebar-icon">

                            <a id="navbarDropdown user-name" class="nav-link dropdown-toggle" href="#"
                                role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                v-pre>
                                {{ Auth::user()->name }}
                            </a>
                            <img src="{{ asset('assets/logout.png') }}">

                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="{{ route('changepass') }}" id="ddown-style">
                                    {{ __('Change Password') }}
                                </a>
                                <a class="dropdown-item" href="{{ route('settings') }}" id="ddown-style">
                                    {{ __('Settings') }}
                                </a>

                                <a class="dropdown-item" href="{{ route('logouts') }}" id="ddown-style"
                                    onclick="event.preventDefault();
                                                        document.getElementById('logout-form').submit();">
                                    {{ __('Logout') }}
                                </a>

                                <form id="logout-form" action="{{ route('logouts') }}" method="POST"
                                    class="d-none">
                                    @csrf
                                </form>
                            </div>
                        </div>
                    </div>

                </div>

                <div id="cashier" class="flex-grow-1 d-flex flex-column">
                    <main class="flex-grow-1 d-flex flex-column">
                        @yield('content')

                        <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>

                        <x-livewire-alert::scripts />
                    </main>
                </div>
            </div>

            {{-- @auth --}}
            {{-- <nav class="navbar navbar-expand-md navbar-light shadow-sm" id="myNavbar" style="background-color: rgba(96, 165, 250, 0.5) !important;">
            <div class="container">
                <a class="navbar-brand" href="{{ url('/') }}">
                    Home
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="{{ __('Toggle navigation') }}">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav me-auto">
                        @auth
                        <li class="nav-item ">
                            <a class="nav-link {{ request()->routeIs('welcome.*') ? 'active' : '' }}" href="{{ route('welcome.dashboard') }}">{{ __('Cashier') }}</a>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link {{ request()->routeIs('member.*') ? 'active' : '' }}" href="{{ route('member.index') }}">{{ __('Member') }}</a>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link {{ request()->routeIs('item') ? 'active' : '' }}" href="{{ route('item') }}">{{ __('Item') }}</a>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link {{ request()->routeIs('opname') ? 'active' : '' }}" href="{{ route('opname') }}">{{ __('Opname') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('activity-log') ? 'active' : '' }}" href="{{ route('activity-log') }}">{{ __('Activity') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('salesemp') ? 'active' : '' }}" href="{{ route('salesemp') }}">{{ __('Sales Employee') }}</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle {{ request()->routeIs('it.*') ? 'active' : '' }}" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                {{ __('IT') }}
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" href="{{ route('it.itin') }}">{{ __('IT In') }}</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="{{ route('it.itout') }}">{{ __('IT Out') }}</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="{{ route('it.itreq') }}">{{ __('IT Request') }}</a></li>
                            </ul>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle {{ request()->routeIs('report.*') ? 'active' : '' }}" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                {{ __('Report') }}
                            </a>
                            <ul class="dropdown-menu text-center" aria-labelledby="navbarDropdown">
                                <li><a class="dropdown-item" href="{{ route('report.reportinvoicereturnsale') }}">{{ __('Report Sale & Return Sale') }}</a></li>
                                <li>
                                    <hr class="dropdown-divider">
                                </li>
                                <li><a class="dropdown-item" href="{{ route('report.reporttransactionmember') }}">{{ __('Member') }}</a></li>
                                <li><hr></li>
                                <li><a class="dropdown-item" href="{{ route('report.voucher') }}">{{ __('Voucher') }}</a></li>

                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('synchronization') ? 'active' : '' }}" href="{{ route('synchronization') }}">{{ __('Synchronization') }}</a>
                        </li>
                        @endauth
                    </ul>
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item dropdown">
                            <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                {{ Auth::user()->name }}
                            </a>

                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="{{ route('changepass') }}">
                                    {{ __('Change Password') }}
                                </a>
                                <a class="dropdown-item" href="{{ route('settings') }}">
                                    {{ __('Settings') }}
                                </a>

                                <a class="dropdown-item" href="{{ route('logouts') }}" onclick="event.preventDefault();
                                                        document.getElementById('logout-form').submit();">
                                    {{ __('Logout') }}
                                </a>

                                <form id="logout-form" action="{{ route('logouts') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="mx-2" style="cursor: pointer;">
                    <a id="toggleThemeButton">
                        <span id="themeIcon" class="bi bi-moon-fill fs-5"></span>
                    </a>
                </div>
            </div>
        </nav> --}}
            {{-- @endauth --}}
            {{-- <main class="py-4">
                @yield('content')
    
                <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>
    
                <x-livewire-alert::scripts />
            </main>
          </div> --}}

        </div>

        <!-- Include jQuery -->
        <script src="{{ asset('assets/js/jquery-3.7.0.js') }}"></script>

        <!-- Include DataTables core script -->
        <script src="{{ asset('assets/js/jquery.dataTables.min.js') }}"></script>

        <!-- Include DataTables Bootstrap 5 extension script -->
        <script src="{{ asset('assets/js/dataTables.bootstrap5.min.js') }}"></script>
        <script>
            $(document).ready(function() {
                $.fn.dataTable.ext.errMode = 'none';
                var table = $('#example').DataTable();

                $(document).keypress(function(e) {
                    // Check if the pressed key is '/' (forward slash)
                    if (e.which == 47) {
                        e.preventDefault(); // Prevent default action
                        // Focus on the search input field of the DataTable
                        $('.dataTables_filter input').focus();
                    }
                    // Check if the pressed key is '.' (period) for next page
                    else if (e.which == 46) {
                        e.preventDefault(); // Prevent default action
                        table.page('next').draw('page');
                    }
                    // Check if the pressed key is ',' (comma) for previous page
                    else if (e.which == 44) {
                        e.preventDefault(); // Prevent default action
                        table.page('previous').draw('page');
                    }
                });
            });

            document.addEventListener("DOMContentLoaded", function() {
                const currentTheme = localStorage.getItem('theme') ||
                    'light'; // Get the stored theme or default to 'dark'
                document.documentElement.setAttribute('data-bs-theme', currentTheme);

                // Set the icon based on the theme
                const themeIcon = document.getElementById('themeIcon');
                if (currentTheme === 'dark') {
                    themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
                } else {
                    themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
                }
            });

            const toggleThemeButton = document.getElementById('toggleThemeButton');
            toggleThemeButton.addEventListener('click', () => {
                const currentTheme = document.documentElement.getAttribute('data-bs-theme');
                let newTheme = 'dark';

                if (currentTheme === 'dark') {
                    newTheme = 'light';
                    themeIcon.classList.replace('bi-moon-fill', 'bi-sun-fill');
                } else {
                    newTheme = 'dark';
                    themeIcon.classList.replace('bi-sun-fill', 'bi-moon-fill');
                }

                document.documentElement.setAttribute('data-bs-theme', newTheme);
                localStorage.setItem('theme', newTheme); // Store the theme in local storage
            });

            document.addEventListener("DOMContentLoaded", function() {
                var navLinks = document.querySelectorAll('.nav-link');
                var currentPage = window.location.pathname.split('/').pop();

                navLinks.forEach(function(link) {
                    if (link.getAttribute('href') === currentPage) {
                        link.classList.add('active');
                    }
                });
            });
        </script>
        @stack('scripts')
</body>

</html>
