@extends('layouts.header')

@section('content')
<style>
  body {
    font-family: 'Poppins', sans-serif;
    background-color: #eef2f3;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    margin: 0;
  }

  .card2 {
    width: 100%;
    max-width: 400px;
    border-radius: 15px;
    box-shadow: 0px 8px 15px rgba(0, 0, 0, 0.1);
  }

  .card-body {
    padding: 2rem;
  }

  .logo {
    text-align: center;
    margin-bottom: 1.5rem;
  }

  .logo img {
    width: 170px;
    height: auto;
  }

  .form-label {
    font-size: 0.9rem;
    margin-bottom: 0.5rem;
    font-weight: bold;
  }

  .form-control {
    border: none;
    border-radius: 20px;
    padding: 12px 15px;
    margin-bottom: 1rem;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    transition: box-shadow 0.3s ease;
  }

  .form-control:focus {
    outline: none;
    box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.2);
  }

  .btn-login {
    background-color: #007bff;
    color: #fff;
    border: none;
    border-radius: 20px;
    padding: 10px 20px;
    font-size: 1rem;
    cursor: pointer;
    transition: background-color 0.3s ease;
  }

  .btn-login:hover {
    background-color: #0056b3;
  }

  .forgot-password {
    font-size: 0.85rem;
    text-align: center;
    margin-top: 1rem;
  }

  .register-link {
    font-size: 0.9rem;
    text-align: center;
    margin-top: 1rem;
  }

  .register-link a {
    color: #007bff;
    text-decoration: none;
    transition: color 0.3s ease;
  }

  .register-link a:hover {
    color: #0056b3;
  }

  .error-message {
    color: #dc3545;
    font-size: 0.85rem;
    margin-top: 0.25rem;
  }
  body{
    background: radial-gradient(circle, var(--cashier-color) 1%, transparent 5%),
                radial-gradient(circle, var(--cashier-color) 1%, transparent 3%);
    background-size: 30px 30px; /* Ukuran polkadot */
    background-position: 0 0, 15px 15px;
  }
</style>
<div class="login-container">
    <div class="row justify-content-center">
      <div class="col-lg-12 ">
          <div class="login-card p-lg-3 shadow-lg">
              <div class="card-body">
                <div class="logo">
                  <img src="{{asset('assets/SoftComp - Logo-01.png')}}" width="170px" height="65px" alt="Deskripsi Gambar">
                </div>
                <div class="">
                  <form method="POST" action="{{ route('logins') }}" class="pt-3">
                    @if($errors->any())
                        <div class="mx-2 alert alert-danger">
                            <span>
                                @foreach ($errors->all() as $error)
                                   {{ $error }}
                                @endforeach
                            </span>
                        </div>
                    @endif
                      @csrf
                    <div class="mb-3">
                      <label for="inputusername" class="form-label login-text">Username</label>
                      <input type="text" name="name" class="form-control rounded-pill" id="inputusername" placeholder="Username" @if(isset($_COOKIE["name"])) value="{{ $_COOKIE["name"] }}" @endif>
                      @error('name')
                          <span class="invalid-feedback" role="alert">
                              <strong>{{ $message }}</strong>
                          </span>
                      @enderror
                  </div>
                    <div class="mb-3">
                      <label for="inputPassword" class="form-label login-text">Password</label>
                      <input type="password" name="password" class="form-control rounded-pill" id="inputPassword" placeholder="Password"  @if(isset($_COOKIE["password"])) value="{{ $_COOKIE["password"] }}" @endif>
                      @error('password')
                          <span class="invalid-feedback" role="alert">
                              <strong>{{ $message }}</strong>
                          </span>
                      @enderror
                  </div>
                    <div class="bot-login">
                      <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="check" name="remember"  @if(isset($_COOKIE["name"])) checked @endif>
                        <label class="form-check-label login-text" for="check">Remember me</label>
                      </div>
                    </div>
                    <div class="d-grid gap-2 col-4 mx-auto my-4">
                      <button class="custom-button1 px-3 py-2 rounded-pill" type="submit">Submit</button>
                    </div>
                    <div class="bot-login register-link">
                      <span class="login-text">Don't have Account? <a href="/register" onclick="register()" class="">Sign Up</a></span>
                      <br><a href="{{ route('forgotpassword') }}"><span class="">Reset Password</span></a>
                    </div>
                  </form>
                </div>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection