<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItReq extends Model
{
    use HasFactory;

    protected $table = 'Luv2_it_req';
    protected $fillable = [
        'whs_code',
        'whs_code_from',
        'date',
        'no',
        'canceled',
        'comments',
        'detail',
    ];

    public function whs()
    {
        return $this->belongsTo(Warehouse::class, 'whs_code', 'code');
    }

    public function whsFrom()
    {
        return $this->belongsTo(Warehouse::class, 'whs_code_from', 'code');
    }

    public function details()
    {
        return $this->belongsTo(ItReqDetail::class, 'no', 'no');
    }

}
