<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItOut extends Model
{
    use HasFactory;

    protected $table = 'Luv2_it_out';
    protected $fillable = [
        'whs_code',
        'whs_code_to',
        'date',
        'no',
        'canceled',
        'comments',
        'detail',
    ];

    public function whs()
    {
        return $this->belongsTo(Warehouse::class, 'whs_code', 'code');
    }

    public function whsTo()
    {
        return $this->belongsTo(Warehouse::class, 'whs_code_to', 'code');
    }

    public function detailsout()
    {
        return $this->belongsTo(ItOutDetail::class, 'no', 'no');
    }
}
