<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;
    protected $table = 'Luv2_invoice';

    protected $fillable =
    [
        'id',
        'id_user',
        'id_member',
        'no',
        'payment',
        'paid',
        'change',
        'must_paid',
        'date',
        'note',
        'promo',
        'no_inv',
        'sync',
        'created_at',
        'updated_at',
        'subtotal',
        'disc_total',
        'id_sales',
        'total_qty',
        'cardcode',
        'sandbox',
        'cashback'
    ];

    public function detailInvoices()
    {
        return $this->hasMany(DetailInvoice::class, 'invoice', 'no');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user', 'id');
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'id_member', 'code');
    }
    
}
