<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DetailInvoice extends Model
{
    use HasFactory;
    protected $table = 'Luv2_detailinvoice';
    protected $fillable = 
    [
        'code',
        'barcode',
        'name',
        'price',
        'nprice',
        'qty',
        'disc',
        'invoice',
        'id_member',
        'id_sales',
        'id_user',
        'total_price',
        'status',
        'id_return',
        'sandbox',
        'promo',
        'pack',
        'promo_tipe',
        'created_at',
        'updated_at',
    ];

    public function member()
    {
        return $this->belongsTo(Member::class, 'id_member', 'code');
    }

    public function item()
    {
        return $this->belongsTo(Item::class, 'code', 'code');
    }

    public function kasir()
    {
        return $this->belongsTo(User::class, 'id_user', 'id');
    }

    public function sales()
    {
        return $this->belongsTo(Sales::class, 'id_sales', 'code');
    }
    
    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice', 'invoice');
    }
}
