<?php

namespace App\Livewire\Returnsale;

use App\Models\Item;
use App\Models\ItemPrice;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Jantinnerezo\LivewireAlert\LivewireAlert;


class Searchproduct extends Component
{
    use LivewireAlert;

    public $key;
    public $filteredProducts;
    public $searchTerm;
    public $selectedItemsPrice;
    public $selectedProduct;
    public $price;
    public $dataInputs = [];
    public $results = [];
    public $index;


    public function __construct()
    {
        $this->key = uniqid();
        $this->dataInputs = [];
    }

    public function selectProductByName($index)
    {
        $product = Item::where('barcode', $this->searchTerm)
            ->orWhere('code', $this->searchTerm)
            ->where('sales', 'Y')
            ->first();

        if ($product) {
            $itemCode = $product->code;

            $this->selectedProduct = $product;
            $this->searchTerm = $itemCode;
            $this->alert('info', $product->name . ' Selected', [
                'position' => 'top-end',
                'timer' => 3000,
                'width' => '500',
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->searchTerm = $product->barcode;
            $this->dispatch('item-selected', index: $index, product: $product, selectedItem: $itemCode);
        } else {
            $productcheck = Item::where('barcode', $this->searchTerm)
                ->orWhere('code', $this->searchTerm)
                ->first();
            if ($productcheck) {
                $this->alert('info', 'Item is Non Sales', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'width' => '500',
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            } else {
                $this->alert('error', 'Item Not Found', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'width' => '500',
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function selectProductByClick($index, $itemCode)
    {
        $product = Item::where('code', $itemCode)
            ->where('sales', 'Y')
            ->first();
        if ($product) {
            $itemCode = $product->code;

            $this->selectedProduct = $product;
            $this->searchTerm = $itemCode;
            $this->alert('info', $product->name . ' Selected', [
                'position' => 'top-end',
                'timer' => 3000,
                'width' => '500',
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->searchTerm = $product->barcode;
            $this->dispatch('item-selected', index: $index, product: $product, selectedItem: $itemCode);
        } else {
            $productcheck = Item::where('code', $itemCode)
                ->first();
            if ($productcheck) {
                $this->alert('info', 'Item is Non Sales', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'width' => '500',
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            } else {
                $this->alert('error', 'Item Not Found', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'width' => '500',
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }
    public function loadFilteredProducts()
    {
        $user = Auth::user();
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $id_pricelist = $wh->id_pricelist;
        $this->filteredProducts = DB::table('Luv2_item')
            ->join('Luv2_item_pricelist', 'Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
            ->where('Luv2_item_pricelist.id_pricelist', $id_pricelist)
            ->where('Luv2_item_pricelist.price', '<=', intval($this->selectedItemsPrice))
            ->where('Luv2_item.code', 'ILIKE', '%' . $this->searchTerm . '%')
            ->orWhere('barcode', 'LIKE', '%' . $this->searchTerm . '%')
            ->orWhere('name', 'ILIKE', '%' . $this->searchTerm . '%')
            ->select('Luv2_item.*')
            ->orderBy('Luv2_item_pricelist.price', 'asc')
            ->take(20)
            ->get();

        foreach ($this->filteredProducts as $product) {
            $product->itemPrices = ItemPrice::where('item_code', $product->code)->where('id_pricelist', $id_pricelist)->get();
        }
    }

    public function updatedSearchTerm()
    {
        $this->loadFilteredProducts();
        $this->selectedProduct = null;
        $this->dispatch('clear-product', index: $this->index);
        $this->dispatch('search-updated', data: $this->filteredProducts);
    }

    public function selectedItemChanged($selectedItem, $index)
    {
        $this->dispatch('item-selected', data: [$selectedItem, $index]);
    }

    public function selectProduct($indexinput, $indexitem)
    {
        // dd($this->results[$indexitem]->code);
        $itemCode = $this->results[$indexitem]->code;
        $product = Item::where('code', $itemCode)
            ->where('sales', 'Y')
            ->first();
        if ($product) {
            $itemCode = $product->code;

            $this->selectedProduct = $product;
            $this->searchTerm = $itemCode;
            $this->alert('info', $product->name . ' Selected', [
                'position' => 'top-end',
                'timer' => 3000,
                'width' => '500',
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->searchTerm = $product->barcode;
            $this->dispatch('item-selected', index: $indexinput, product: $product, selectedItem: $itemCode);
        } else {
            $productcheck = Item::where('code', $itemCode)
                ->first();
            if ($productcheck) {
                $this->alert('info', 'Item is Non Sales', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'width' => '500',
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            } else {
                $this->alert('error', 'Item Not Found', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'width' => '500',
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function render()
    {
        $results = [];
        $user = Auth::user();
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $id_pricelist = $wh->id_pricelist;

        if (strlen($this->searchTerm) >= 1) {
            $results =  DB::table('Luv2_item')
                ->join('Luv2_item_pricelist', 'Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
                ->where('Luv2_item_pricelist.id_pricelist', $id_pricelist)
                ->where('Luv2_item_pricelist.price', '<=', intval($this->selectedItemsPrice))
                ->where('Luv2_item.code', 'ILIKE', '%' . $this->searchTerm . '%')
                ->orWhere('barcode', 'LIKE', '%' . $this->searchTerm . '%')
                ->orWhere('name', 'ILIKE', '%' . $this->searchTerm . '%')
                ->select('Luv2_item.*')
                ->orderBy('Luv2_item_pricelist.price', 'asc')
                ->take(20)
                ->get();
            $this->results = $results;
        }
        return view('livewire.returnsale.searchproduct', [
            'product' => $results,
        ]);
    }
}
