<?php

namespace App\Livewire\Report;

use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Checkbox extends Component
{

    public $cardcode;
    public $selectAll;
    public $checkboxes = [];

    public function mount()
    {
        $uniqueCardCodes = DB::table('Luv2_invoice')
                    ->distinct()
                    ->pluck('cardcode');           
        $cardcodes = $uniqueCardCodes; 
        $this->cardcode = $cardcodes;

    }
    public function selectAllClick()
    {
        if (empty($this->checkboxes)) {
            $this->selectAll = true;

            $this->checkboxes = array_fill_keys($this->cardcode->toArray(), true);
        } else {
        $this->checkboxes = [];
        $this->selectAll = false;

        }
        $this->dispatch('refreshjs');

    }
    
    public function updateCheckboxes($crdcd)
    {
        $this->checkboxes[$crdcd] = !$this->checkboxes[$crdcd];
        $this->dispatch('putCheckbox', $this->checkboxes)->to(Bjrs::class);
    }
    public function render()
    {
        return view('livewire.report.checkbox');
    }
}
