<?php

namespace App\Livewire\Pos\Member;

use App\Models\Member;
use Carbon\Carbon;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class MemberTable extends Component
{
    use LivewireAlert;
    public $members;

    #[On('refreshtable')]
    public function mount()
    {
        $this->dispatch('refreshjs');
        $this->members = Member::get();
    }

    public function updateStatus($code)
    {
        $currentTime = Carbon::now();
        $member = Member::where('code',$code)->first();

        if ($member->active === 'Y') {
            $member->update([
                'active' => 'N',
                'updated_at' => $currentTime,
            ]);
        } else {
            $member->update([
                'active' => 'Y',
                'updated_at' => $currentTime,
            ]);
        }
        $this->alert('success', 'Status changed succesfully', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->dispatch('refreshtable');
    }


    public function render()
    {
        return view('livewire.pos.member.member-table');
    }
}
