<?php

namespace App\Livewire\Pos\It\ItOut;

use App\Models\ItOut;
use Livewire\Attributes\On;
use Livewire\Component;

class ItOutTable extends Component
{

    public function render()
    {
            $its = ItOut::with(['whsTo', 'detailsout'])
            // ->where('canceled', 'N')
            ->withSum('detailsout', 'qty')
                ->orderBy('Luv2_it_out.date', 'desc')
                ->orderBy('Luv2_it_out.no', 'desc')
                ->get();
            $totalSumQty = $its->sum('detailsout_sum_qty');
        return view('livewire.pos.it.itout.it-out-table', compact('its', 'totalSumQty'));
    }

    public function detail($it)
    {
        return redirect()->route('it_out_detail', ['it' => $it]);
    }

    #[On('refresh')]
    public function updated()
    {
    }
}
