<?php

namespace App\Http\Controllers;

use App\Models\Auths;
use App\Models\Invoice;
use App\Models\ItOut;
use App\Models\ItReqOut;
use App\Models\Member;
use App\Models\Settings;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $countinv = Invoice::where('sandbox', 'Y')->count();
        $setting = Settings::first();
        return view('welcome.home', compact('countinv', 'setting'));
    }

    public function display()
    {
        $countinv = Invoice::where('sandbox', 'Y')->count();
        $setting = Settings::first();
        return view('welcome.display', compact('countinv', 'setting'));
    }

    public function returnsale()
    {
        return view('welcome.returnsale');
    }

    public function item()
    {
        return view('welcome.item');
    }
    public function opname()
    {
        return view('opname.opname');
    }
    public function resultopname()
    {
        return view('opname.result');
    }

    public function itin()
    {
        return view('it.itin.itin');
    }

    public function itreq()
    {
        return view('it.itreqin.itreq');
    }

    public function itreqout()
    {
        return view('it.itreqout.itreqout');
    }
    public function itreqoutcreate()
    {
        return view('it.itreqout.itreqoutcreate');
    }

    public function itreqoutdetail($it)
    {
        return view('it.itreqout.itreqout-detail', compact('it'));
    }

    public function itreqoutprint($it)
    {
        $details = DB::table('Luv2_it_req_out_detail')
            ->Join('Luv2_it_req_out', 'Luv2_it_req_out_detail.no', '=', 'Luv2_it_req_out.no')
            ->Join('Luv2_item', 'Luv2_it_req_out_detail.item_code', '=', 'Luv2_item.code')
            ->select('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name', DB::raw('SUM("Luv2_it_req_out_detail"."qty") as "qty"'), DB::raw('SUM("Luv2_it_req_out_detail"."qty_send") as "qty_send"'))
            ->where('Luv2_it_req_out.no', $it)
            ->groupBy('Luv2_item.code')
            ->get();

        $no = ItReqOut::with(['whsTo', 'details'])
            ->where('canceled', 'N')
            ->withSum('details', 'qty_send')
            ->orderBy('Luv2_it_req_out.date', 'desc')
            ->orderBy('Luv2_it_req_out.no', 'desc')
            ->first();
        $sumQty = 0;
        $sumQtySend = 0;

        foreach ($details as $detail) {
            $sumQty += $detail->qty;
            $sumQtySend += $detail->qty_send;
        }

        return view('it.itreqout.printitreqout', compact('details', 'no', 'sumQty', 'sumQtySend'));
    }


    public function itindetail($it)
    {
        return view('it.itin.itin-detail', compact('it'));
    }

    public function itreqdetail($it)
    {
        return view('it.itreqin.itreq-detail', compact('it'));
    }

    public function itout()
    {
        $itout = ItOut::get();
        return view('it.itout.itout', compact('itout'));
    }
    public function itoutdetail($it)
    {
        return view('it.itout.itout-detail', compact('it'));
    }
    public function salesemp()
    {
        return view('emp-sales.emp');
    }
    public function reportinvoice()
    {
        $user = Auth::user();
        $invoices = Invoice::whereNull('no_inv')->get();
        $authorization = Auths::where('menu', 'Transaction')
            ->where('modul', 'Sales')->first();

        $hasPermission = $user->authorizations
            ->filter(function ($authorization) {
                return strpos($authorization->auth, 'R') !== false;
            })
            ->contains('id_auth', $authorization->id);

        if ($hasPermission) {
            return view('report.reportinvoice', compact('invoices'));
        } else {
            abort(403);
        }
    }

    public function reportinvoicereturnsale()
    {
        $user = Auth::user();
        $invoices = Invoice::whereNull('no_inv')->get();
        $authorization = Auths::where('menu', 'Transaction')
            ->where('modul', 'Sales')->first();

        $hasPermission = $user->authorizations
            ->filter(function ($authorization) {
                return strpos($authorization->auth, 'R') !== false;
            })
            ->contains('id_auth', $authorization->id);

        if ($hasPermission) {
            return view('report.reportinvoicereturnsale', compact('invoices'));
        } else {
            abort(403);
        }
    }

    public function reportinvoicedetail()
    {
        return view('report.reportinvoicedetail');
    }

    public function reportreturnsale()
    {
        $user = Auth::user();

        $authorization = Auths::where('menu', 'Transaction')
            ->where('modul', 'Sales Return')->first();

        $invoices = Invoice::whereNotNull('no_inv')->get();
        $hasPermission = $user->authorizations
            ->filter(function ($authorization) {
                return strpos($authorization->auth, 'R') !== false;
            })
            ->contains('id_auth', $authorization->id);

        if ($hasPermission) {
            return view('report.reportreturnsale', compact('invoices'));
        } else {
            abort(403);
        }
    }
    public function reportvoucher()
    {
        return view('report.reportvoucher');
    }

    public function reporttransactionmember()
    {
        $members = Member::withCount(['invoices' => function ($query) {
            $query->whereNotNull('code'); 
        }])
            ->whereHas('invoices', function ($query) {
                $query->whereNotNull('code'); 
            })
            ->orderBy('invoices_count', 'desc')
            ->get();
        return view('report.reporttransactionmember', compact('members'));
    }

    public function settings()
    {
        return view('auth.settings');
    }
    public function changepass()
    {
        return view('auth.changepassword');
    }

    public function forgotpass()
    {
        return view('auth.forgotpassword');
    }

    /**
     * Show the form for creating a new resource.
     */

    public function welcome()
    {
        $user = Auth::user();

        return view('welcome.welcome', compact('user'));
    }

    public function welcomeregister()
    {
        return view('welcome.welcomeregister');
    }

    public function synchronization()
    {
        return view('synchronization.index');
    }

    public function print($no)
    {
        $invoice = DB::table('Luv2_invoice')
        ->where('no', $no)
        ->leftJoin('Luv2_salesemp', 'Luv2_invoice.id_sales', '=', 'Luv2_salesemp.code')
        ->leftJoin('Luv2_users', 'Luv2_invoice.id_user', '=', 'Luv2_users.id')
        ->select(
            'Luv2_invoice.*',
            'Luv2_salesemp.name as sales_name',
            'Luv2_users.name as users_name'
        )->first();

        $detail = DB::table('Luv2_detailinvoice')
        ->where('Luv2_detailinvoice.invoice', $no)
        ->get();
        $setting = Settings::first();

        $footer = str_replace('\n', '<br>', $setting->receipt_footer);
        return view('report.print', compact('invoice', 'detail', 'footer', 'setting'));
    }
}
